#ifndef _INCLUDE_W3300_H_
#define _INCLUDE_W3300_H_

#include <assert.h>

// some simple type definitions

#ifdef __GNUC__
    typedef unsigned long long uint64;
    typedef   signed long long  int64;
#else
    typedef unsigned __int64 uint64;
    typedef   signed __int64  int64;
#endif
typedef unsigned long  uint32;
typedef   signed long   int32;
typedef unsigned short uint16;
typedef   signed short  int16;
typedef unsigned char  uint8;
typedef   signed char   int8;

// debugging aid
#ifdef _DEBUG
    #define ASSERT(b) assert(b)
#else
    #define ASSERT(b)
#endif

// generic status values
#define EMU_OK   0
#define EMU_FAIL 1

// used for in term3315 and term3315_pun indexing two tape units
enum unit_t { rdr_unit, pun_unit, end_unit };

// used to signal that something has changed in the tape interface
// the bitmap may be OR'd to signal multiple changes
enum punch_event_t {
    pe_mount    = 0x0001,  // tape was mounted or unmounted
    pe_position = 0x0002,  // tape position changed
    pe_punchen  = 0x0004,  // punch enable state changed
    pe_all      = 0x0007   // indicate everything has changed
    };

// =============================================================
// host specific defines
// =============================================================

#if defined(__WXMSW__)
    #include <windows.h>        // _MAX_PATH and GetFullPathName()
    #define MAX_PATHLEN (_MAX_PATH)
#elif defined(PATH_MAX)
    #define MAX_PATHLEN (PATH_MAX)
#else
    #define MAX_PATHLEN (512)
#endif

#endif // _INCLUDE_W3300_H_
