// emulate a Wang 3315 terminal, which is a rebadged ASR33 TTY.
//

#ifndef _TERM3315_H_
#define _TERM3315_H_

#include "IoDevice.h"

// forward class references
class term3315_kbd;
class term3315_prt;
class term3315_pun;
class cpu3300;
class Scheduler;
class UiTerm3315;

// ======================================================================
// This is mostly a shell that proxies methods to pimpl subcomponents:
//    term3315_kbd, term3315_prt, term3315_pun
//    (keyboard)    (printer)     (reader/punch)
// ======================================================================

class term3315: public IoDevice
{
public:
    // create terminal #"termnum" and attach it to the CPU
    term3315(cpu3300 *cpu, Scheduler &scheduler, int termnum);

    // clean up
    ~term3315();

    // mechanism for UI to notify us of keystroke to our terminal
    void Keystroke(uint8 keycode);

    // overridden IoDevice methods
    void Reset();
    void Clear();
    void WrControl(int addr, int data);
    int  RdStatus(int addr) const;
    void WrData(int addr, int data);
    int  RdData(int addr) const;
    void IAck(int addr);

    // paper tape file attributes
    bool  TapeMounted(const unit_t unit) const;
    void  MountTape(const unit_t unit, const char *filename);
    void  UnmountTape(const unit_t unit);
    char *GetTapePath(const unit_t unit) const;
    int   TapePosition(const unit_t unit);
    void  SetTapePosition(const unit_t unit, int position);

    // paper tape reader/punch enable switches
    void ReaderStart();
    void ReaderStop();
    bool ReaderEnabled() const;
    bool PunchEnabled() const;
    void SetPunchEnabled(bool enable);

private:
    UiTerm3315   *m_ui;                 // user interface routines
    term3315_kbd *m_kbd;                // keyboard
    term3315_prt *m_prt;                // printer
    term3315_pun *m_pun;                // punch
    bool          m_initialized;        // true after construction is done

    bool Initialized() const { return m_initialized; }
};

#endif // _TERM3315_H_
