#ifndef _INCLUDE_DASM_H_
#define _INCLUDE_DASM_H_

// maximum length output from dasm3300
#define DASM3300_MAX_LENGTH 100

// given a 16b instruction, fill an external buffer with the disassembled
// version of that instruction.  returns 0 if OK, -1 if illegal operation.
// if the state of the P flag is known, better results can be produced.
// p should be -1 (unknown), 0, or 1.
int dasm3300(uint16 addr, uint16 instr, char *buff, int p=-1);

// generic status values
#define EMU_OK   0
#define EMU_FAIL 1

#endif // _INCLUDE_DASM_H_
