// This file contains program images in a C byte array form.
// Each program is made up of a number of segments, structured like this:
//
//      seg_length_msb, seg_length_lsb,
//      load_addr_msb,  load_addr_msb, 
//      byte 0, byte 1, ..., byte (seg_length-1)
//
//      seg_length_msb, seg_length_lsb,
//      load_addr_msb,  load_addr_msb, 
//      byte 0, byte 1, ..., byte (seg_length-1)
//   ...
//      0x00, 0x00
//
// That is, the first two bytes indicate the length of the next segment;
// a length of zero indicates no more segments.  The next two bytes are
// the load address of the following data, followed by the data to load.

#include "bootstrap.h"

// ########################################################################
// TELETYPE BOOTSTRAP PROGRAM LISTINGS
// For 8-bit TTYLOAD, TCBOOT #1 & #2
// ########################################################################

// This is the boot program that appears on page 15 of the 3300 Developer's
// Manual.  It is keyed in at the front panel in order to load the second-
// level paper tape or cassette bootstrap program.  It is designed to be
// as simple and small as possible.
//
// NOTE:
//  (1) TTYLOAD is generally loaded into the last page of available memory
//      although it may be loaded into any page.  The starting address of
//      where the loader is to be entered is contained in locations 20 and 21.
//      Therefore,
//          location 0020 = 0F for a 4K system
//          location 0020 = 1F for an 8K system
//          location 0020 = 2F for a 12K system, etc.
//  (2)  TCBOOT is always loaded at 2F40.
//  (3)  Locations 0020, 0021, and 0022 must be restored if the BOOTSTRAP
//       is used more than once.
//
// NOTE:
//  The BOOTSTRAP program for loading the 4-b TTY loader is identical except
//  that the byte at RCNT is X'44' instead of X'61', due to the fact that
//  the 4-bit bootstrap program is longer.

uint8 bootstrap[] = {

    // segment header
    0x00, 0x23,  // length
    0x00, 0x00,  // load address

    0x0D, 0x00,  // 0000 BOOT OFS  X'FF'    clear status flags
    0x1B, 0x20,  // 0002      LZI  X'20'    device address X'20'
    0x1A, 0x83,  // 0004      LAI  X'83'    clear the device for input
    0x3C, 0x08,  // 0006      CIOJ          send control byte
    0x30, 0xB0,  // 0008      STI  X'B0'    test for character ready
    0x46, 0x08,  // 000A      JMP  *-2      wait for it
    0xC3, 0x1E,  // 000C      LA*  BUFF     read character
    0x19, 0x00,  // 000E      CI   0        is it a null byte?
    0x14, 0x01,  // 0010      STS  X'01'    keep going once we've started
    0x27, 0x00,  // 0012      JEQ  BOOT     skip leading null bytes
    0x0C, 0x01,  // 0014      ONS  X'01'    indicate load has started
    0xCE, 0x20,  // 0016      UA+  LADR     save byte to load buffer
    0x42, 0x22,  // 0018      INC  RCNT     byte counter
    0x25, 0x02,  // 001A      JNZ  BOOT+2   get next character until done
    0x00, 0x1C,  // 001C      HLTJ *        hang until operator restart
    0x02, 0x20,  // 001E BUFF DAC  X'0220'  pointer to input char buffer
    0x2F, 0x40,  // 0020 LADR DAC  X'2F40'  pointer to storage
    0x61,        // 0022 RCNT DC   X'61'    complement of length of loaded pgm

    // segment header
    0x00, 0x00  // no more segments
};


// ########################################################################
// CASSETTE LOADER BOOTSTRAP  08/07/72
// For 8-bit TTYLOAD, TCBOOT #1 & #2
// ########################################################################

uint8 tcboot[] = {

    // segment header
    0x00, 0x92,  // length
    0x2F, 0x40,  // load address

                 //      *      EQUATES
                 //      @TCRDY EQU  X'01'
                 //      @TCERR EQU  X'02'
                 //      @TCEOT EQU  X'04'
                 //      @TCFPN EQU  X'08'
                 //      @TCEOB EQU  X'10'
                 //      @TCBOT EQU  X'80'
                 //      @MODFY EQU  X'00'
                 //
    0x0D, 0x00,  // 2F40 TCBOOT OFS  X'FF'    CLEAR STATUS FLAGS
    0x1A, 0x6E,  // 2F42        LAI  X'6E'    LAST CORE MODULE IN COMPUTER
    0xCA, 0xC2,  // 2F44        UA   RESET
    0xCA, 0xC4,  // 2F46        UA   TCMOD3
    0xCA, 0xC6,  // 2F48        UA   TCMOD4
    0xCA, 0xC8,  // 2F4A        UA   TCMOD5
    0x18, 0x01,  // 2F4C        AI   1
    0xCA, 0xCA,  // 2F4E        UA   TCMOD1
    0xCA, 0xCC,  // 2F50        UA   TCMOD2
    0xCA, 0xCE,  // 2F52        UA   TCLUNT
    0xCA, 0xD0,  // 2F54        UA   TCLOAD
    0xD2, 0xC0,  // 2F56        LZ   TCUNIT
    0x1A, 0x80,  // 2F58        LAI  X'80'
    0x30, 0x80,  // 2F5A        STI  @TCBOT
    0x00, 0x5C,  // 2F5C TCBHLT HLTJ *        BAD LOAD
    0x3C, 0x60,  // 2F5E        CIOJ          START READ
    0xB2, 0xC2,  // 2F60 SETPTR DL   RESET
    0xBA, 0x82,  // 2F62        DU   TCBPTR
    0x4E, 0x86,  // 2F64        JST  TCRD2    READ BYTES 1,2
    0x4E, 0x86,  // 2F66        JST  TCRD2    READ BYTES 3,4
    0xBA, 0x84,  // 2F68        DU   TCBCTR
    0x4E, 0x86,  // 2F6A        JST  TCRD2    READ BYTES 5,6
    0x4E, 0x86,  // 2F6C        JST  TCRD2    READ BYTES 7,8
    0x4E, 0x86,  // 2F6E        JST  TCRD2    READ TEXT PTR
    0x19, 0xC8,  // 2F70        CI   X'C8'
    0x25, 0x5C,  // 2F72        JNE  TCBHLT
    0x4E, 0x86,  // 2F74 TCB1   JST  TCRD2    READ TEXT
    0xBE, 0x82,  // 2F76        DU+  TCBPTR
    0x1C, 0xFE,  // 2F78        DLI  -2
    0xAA, 0x84,  // 2F7A        DAM  TCBCTR
    0x25, 0x74,  // 2F7C        JNZ  TCB1
                 //      *      meaningful data loaded
    0x4E, 0x86,  // 2F7E TCB2   JST  TCRD2    READ OTHER FILLER
    0x46, 0x7E,  // 2F80        JMP  TCB2
                 //      *
    0x2F, 0x82,  // 2F82 TCBPTR DAC  *
    0x2F, 0x84,  // 2F84 TCBCTR DAC  *
                 //      *
    0x2F, 0x86,  // 2F86 TCRD2  DAC  *
    0x4E, 0x92,  // 2F88        JST  TCRD1
    0xCA, 0x8F,  // 2F8A        UA   *+5
    0x4E, 0x92,  // 2F8C        JST  TCRD1
    0x1B, 0x00,  // 2F8E        LZI  @MODFY
    0x47, 0x86,  // 2F90        JMP* TCRD2
                 //      *
    0x2F, 0x92,  // 2F92 TCRD1  DAC  *
    0xD2, 0xC0,  // 2F94        LZ   TCUNIT
    0x31, 0xE9,  // 2F96        SFI  @TCEOB+@TCERR+@TCEOT
    0x46, 0xA2,  // 2F98        JMP  TCREOB
    0x31, 0xFE,  // 2F9A        SFI  @TCRDY
    0x46, 0x96,  // 2F9C        JMP  *-6
    0x3A, 0xA0,  // 2F9E        RDDJ          A=BYTE READ
    0x47, 0x92,  // 2FA0        JMP  *TCRD1
                 //      *
    0x31, 0xF9,  // 2FA2 TCREOB SFI  @TCERR+@TCEOT
    0x00, 0xA4,  // 2FA4        HLTJ *
    0xB2, 0x84,  // 2FA6        DL   TCBCTR
    0x25, 0x5C,  // 2FA8        JNZ  TCBHLT
    0xB2, 0xC0,  // 2FAA        DL   TCUNIT
    0xBB, 0xCE,  // 2FAC        DU*  TCLUNT   SET TC UNIT INTO REGULAR LOADER
    0xC2, 0xC4,  // 2FAE        LA   TCMOD3   SET RELOCATABLE ADDRESSES
    0xCB, 0xCA,  // 2FB0        UA*  TCMOD1
    0xCB, 0xCC,  // 2FB2        UA*  TCMOD2
    0xC2, 0xCA,  // 2FB4        LA   TCMOD1
    0xCB, 0xC4,  // 2FB6        UA*  TCMOD3
    0xCB, 0xC6,  // 2FB8        UA*  TCMOD4
    0xCB, 0xC8,  // 2FBA        UA*  TCMOD5
    0x1C, 0x02,  // 2FBC        DLI  2
    0x47, 0xD0,  // 2FBE        JMP* TCLOAD
    0x40, 0xC1,  // 2FC0 TCUNIT DC   X'40C1'  TAPE CASSETTE UNIT
                 //      ***    THE FOLLOWING DATA MUST DIFFER WITH MAXIMUM MEMORY SIZE
    0x7E, 0xC8,  // 2FC2 RESET  DC   X'7EC8'   (page+0)C8
    0x7E, 0xF6,  // 2FC4 TCMOD3 DC   X'7EF6'   (page+0)F6
    0x7E, 0xF8,  // 2FC6 TCMOD4 DC   X'7EF8'   (page+0)F8
    0x7E, 0xFA,  // 2FC8 TCMOD5 DC   X'7EFA'   (page+0)FA
    0x7F, 0xF6,  // 2FCA TCMOD1 DC   X'7FF6'   (page+1)F6
    0x7F, 0xF8,  // 2FCC TCMOD2 DC   X'7FF8'   (page+1)F8
    0x7F, 0xFF,  // 2FCE TCLUNT DC   X'7FFE'   (page+1)FE
    0x7F, 0x00,  // 2FD0 TCLOAD DC   X'7F00'   (page+1)00
                 //             END       END CARD GENERATED BY ASSEMBLER

    // segment header
    0x00, 0x00  // no more segments
};

