#ifndef _TERM_PAPERTAPE_H_
#define _TERM_PAPERTAPE_H_

#include "term3315.h"           // core emulation routines
#include <wx/tglbtn.h>          // for wxToggleButton

// forward class declaration
class UiTerm3315;


class UiTermPapertape : public wxPanel
{
public:
    UiTermPapertape(UiTerm3315 *parent, term3315 *term_core);
    ~UiTermPapertape();

    // receive notification of papertape state changes
    void PapertapeUpdate(unit_t unit, punch_event_t changed);

private:
    // these make no sense -- declare, but don't define
    UiTermPapertape& operator=(const UiTermPapertape &rhs);   // assignment
    UiTermPapertape(UiTermPapertape &obj);                    // copy constructor

    // event handlers
    void OnMountTape(wxCommandEvent &event);
    void OnRdrButton(wxCommandEvent &event);
    void OnRdrPosEnter(wxCommandEvent &event);
    void OnPunButton(wxCommandEvent &event);
    void OnPunPosEnter(wxCommandEvent &event);

    // callback function to receive tape state updates
    void TapeStateCallback(unit_t unit);

    // data members
    UiTerm3315      *m_parent;          // containing frame
    term3315        *m_term_core;       // core terminal emulator object

    // data members for paper tape reader
    wxTextCtrl      *m_rdr_path;
    wxButton        *m_rdr_mount_btn;
    wxButton        *m_rdr_start_btn;
    wxButton        *m_rdr_stop_btn;
    wxTextCtrl      *m_rdr_position;
    wxButton        *m_rdr_rewind_btn;

    // data members for paper tape punch
    wxTextCtrl      *m_pun_path;
    wxButton        *m_pun_mount_btn;
    wxToggleButton  *m_pun_enable_btn;
    wxTextCtrl      *m_pun_position;

    DECLARE_EVENT_TABLE()
};

#endif // _TERM_PAPERTAPE_H_
