#ifndef _INCLUDE_UI_TERM3315_H_
#define _INCLUDE_UI_TERM3315_H_

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include "w3300.h"

// forward declarations
class UiTerm3315;
class UiTermPapertape;
class term3315;

// ================== this handles the interior of the frame ==================

// define a scrollable canvas for drawing onto
class UiTermPaper: public wxScrolledWindow
{
public:
    UiTermPaper( UiTerm3315 *parent, term3315 *term_core );    // constructor
    ~UiTermPaper();                                            // destructor

    // ---- setters/getters ----
    void SetFontSize(const int size);
    void GetFontSize(int &size);

    void SetPageAttributes( int linelength, int pagelength);
    void GetPageAttributes(int& linelength, int& pagelength);

    void GetCellAttributes(int *cell_w, int *cell_h);

    // ---- other functions ----
    // emit a character to the display
    void OutChar(uint8 byte);

    // save the printer contents to a file
    void SaveToFile();

    // clear the printer contents
    void PrintClear();

    // return the number of pages in the current copy of the printstream
    int NumberOfPages();

    // redraw the scrollbars
    void ScrollbarSet(int xpos, int ypos, bool redraw);

    // return pointer to the core terminal emulation
    term3315* TermCore() { return m_term_core; }

private:
    // these make no sense -- declare, but don't define
    UiTermPaper& operator=(const UiTermPaper &rhs);   // assignment
    UiTermPaper(UiTermPaper &obj);                    // copy constructor

    // ---- event handlers ----
    void OnChar(wxKeyEvent &event);
    void OnPaint(wxPaintEvent &event);
    void OnSize(wxSizeEvent &event);
    void OnEraseBackground(wxEraseEvent &event);

    // ---- utility functions ----
    // redraw entire screen
    void InvalidateAll()  { Refresh(FALSE); }

    // refresh the screen display
    void DrawScreen(wxDC &dc, int startCol, int startRow );

    // emit current buffer to the print stream
    void EmitLine();

    // update the bitmap of the screen image
    void GenerateScreen(int startCol, int startRow);

    // add lines to print stream to account for form feed
    void FormFeed();

    // check redraw of screen and set scrollbars
    void UpdateView();

    // update the statusbar text
    void UpdateStatusbar();

    // ---- member variables ----
    UiTerm3315   *m_parent;             // who owns us
    term3315     *m_term_core;          // core emulation

    // this holds the dimensions of the visible area we have to draw on,
    // which is entirely independent of the logical Term dimensions.
    int         m_scrpix_w;             // display dimension, in pixels
    int         m_scrpix_h;             // display dimension, in pixels

    wxBitmap   *m_scrbits;              // image of the display

    int         m_chars_w;              // screen dimension, in characters
    int         m_chars_h;              // screen dimension, in characters

    wxFont      m_font;                 // font in use
    int         m_fontsize;             // size of font (in points)
    int         m_charcell_w;           // width of one character cell
    int         m_charcell_h;           // height of one character cell

    bool        m_greenbar;             // style of paper

    int         m_linelength;           // the line length of the logical printer
    int         m_pagelength;           // the page length of the logical printer

    wxArrayString m_printstream;        // represents the entire print stream

    DECLARE_EVENT_TABLE()
};

// ================== the main interface ==================

// Define a new frame type: this is going to be our main frame
class UiTerm3315 : public wxFrame
{
public:
    // constructor
    UiTerm3315(const int term_number, term3315 *term_core);

    // destructor
    ~UiTerm3315();

    // called to schedule a window to be closed (deferred)
    bool Destroy();

    // emit a character to the display
    void OutChar(uint8 byte);

    // notify GUI that papertape state has changed
    void PapertapeUpdate(unit_t unit, punch_event_t changed);

    // update the status bar text
    void SetStatusText(const wxString &msg);

    // move focus back on main window
    void Refocus() { m_termpaper->SetFocus(); }

private:

    // these make no sense -- declare, but don't define
    UiTerm3315& operator=(const UiTerm3315& rhs);     // assignment
    UiTerm3315(UiTerm3315& obj);                      // copy constructor

    // ---- event handlers ----

    void OnScript(wxCommandEvent& event);
    void OnQuit(wxCommandEvent& event);
    void OnFileExit(wxCommandEvent& WXUNUSED(event));
    void OnFileSaveAs(wxCommandEvent& WXUNUSED(event));
    void OnFilePrintClear(wxCommandEvent& WXUNUSED(event));
    void OnDisplayPapertape(wxCommandEvent& WXUNUSED(event));
    void OnFontSize(wxCommandEvent& event);

    // called whenever the system has no event to process
    void OnIdle(wxIdleEvent &event);

    // called when the window changes size
    void OnSize(wxSizeEvent& event);

    // called when a menu is opened or closed
    void OnMenuOpen(wxMenuEvent& WXUNUSED(event));
    void OnMenuClose(wxMenuEvent& WXUNUSED(event));

    // called when the window is manually closed ("X" button, or sys menu)
    void OnClose(wxCloseEvent& WXUNUSED(event));

    // ---- utility functions ----

    void MakeMenubar();

    // save/get CRT options to the config file
    void SaveDefaults();
    void GetDefaults();

    void SetMenuChecks();

    // refresh display
    void RefreshWindow();

    // ---- data members ----
    wxBoxSizer         *m_sizer;
    term3315           *m_term_core;
    int                 m_term_number;
    wxMenuBar          *m_menuBar;
    wxStatusBar        *m_statusBar;
    UiTermPaper        *m_termpaper;
    UiTermPapertape    *m_papertape;

    // any class wishing to process wxWindows events must use this macro
    DECLARE_EVENT_TABLE()
};

#endif // _INCLUDE_UI_TERM3315_H_
