#ifndef _UI_SYSTEM_CONFIG_DLG_H_
#define _UI_SYSTEM_CONFIG_DLG_H_

// forward declaration
class SystemConfig;

// modal dialog box for configuring the emulated computer
class SystemConfigDlg : public wxDialog
{
public:
    SystemConfigDlg(wxFrame *parent);   // constructor
    // ~SystemConfigDlg();              // destructor

private:
    SystemConfig *m_config;		// configuration object

    wxCheckBox *hSpeedRegulated;        // whether the CPU emulation is realtime
    wxChoice   *hMemsize;               // main memory size
    wxChoice   *hNumTerms;              // number of terminals
    wxChoice   *hNumCassettes;          // number of cassette drives
#if 0
    wxCheckBox *hWarnIO;        // whether to want on access to non-existing IO devices
                                // the real Wang hardware ignored such actions
                                // the emulator has support to catch such actions, which is
                                // useful for debugging
#endif
    wxButton   *hBtnRevert;
    wxButton   *hBtnOK;
    wxButton   *hBtnCancel;

    // helper routines
    void UpdateDlg();

    // save/get dialog options to the config file
    void SaveDefaults();
    void GetDefaults();

    // ---- event handlers ----
    void OnMemsizeChoice( wxCommandEvent& WXUNUSED(event) );
    void OnSpeedRegulated( wxCommandEvent& WXUNUSED(event) );
    void OnNumTerminals( wxCommandEvent& WXUNUSED(event) );
    void OnNumCassetteDrives( wxCommandEvent& WXUNUSED(event) );
    void OnButton(wxCommandEvent& event);
#if 0
    void OnWarnIO( wxCommandEvent& WXUNUSED(event) );
#endif

    // these make no sense -- declare, but don't define
    SystemConfigDlg& operator=(const SystemConfigDlg& rhs);     // assignment
    SystemConfigDlg(SystemConfigDlg& obj);                      // copy constructor

    DECLARE_EVENT_TABLE()
};

#endif // _UI_SYSTEM_CONFIG_DLG_H_
