#ifndef _INCLUDE_UI_SYSTEM_H_
#define _INCLUDE_UI_SYSTEM_H_

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include "wx/fileconf.h"        // required for wxFileConfig

#include "w3300.h"

// ==================== exported by UiSystem.cpp ====================

// for use by callers to MyApp::FileReq()
enum { FILEREQ_SCRIPT,      // .w33 script files
       FILEREQ_HEX,         // reading/saving .hex files
       FILEREQ_PTAPE_RDR,   // paper tape reader
       FILEREQ_PTAPE_PUN,   // paper tape punch
       FILEREQ_CTAPE,       // cassette tape directory
       FILEREQ_PRINTER,     // printer output
       FILEREQ_NUM,         // number of filereq types
     };

// FileReq() return status
enum { FILEREQ_OK, FILEREQ_CANCEL };

// these are menu IDs so the MyApp::OnHelpLauncher() konws
// what item is chosen.
enum {
        Help_Quickstart = 200,
//      Help_Configure,
//      Help_Keyboard,
//      Help_Menus,
//      Help_Printer,
//      Help_Script,
//      Help_DiskFactory,
//      Help_DiskCheat,
        Help_Website,
        Help_About = wxID_ABOUT,
    };

// a macro to cause the help menu to do something
#define HELP_MENU_EVENT_MAPPINGS() \
    EVT_MENU (Help_Website,          MyApp::OnHelp_Launcher) \
    EVT_MENU (Help_About,            MyApp::OnHelp_About)


// Define a new application type, each program should derive a class from wxApp
class MyApp : public wxApp
{
public:
    // override base class virtuals
    // ----------------------------

    // this one is called on application startup and is a good place for the app
    // initialization (doing it here and not in the ctor allows to have an error
    // return: if OnInit() returns false, the application terminates)
    virtual bool OnInit();

    // set the command line parsing options
    virtual void OnInitCmdLine(wxCmdLineParser& parser);

    // after the command line has been parsed, decode what it finds
    virtual bool OnCmdLineParsed(wxCmdLineParser& parser);

    // called whenever there is nothing else to do
    void OnIdle(wxIdleEvent &event);

    // This is called just before quitting the entire app,
    // but before wxWindows cleans up its internal resources.
    virtual int OnExit();

    // shut down the application
    static void Terminate();

    // indicate user wants to reconfigure the system
    static void Reconfigure();

    // Utility function that serves all others.
    // Ask user to provide a file location.
    static int FileReq(int requestor, wxString title, int readonly, wxString *fullpath);

    // create a help menu, used for all frames that care
    static wxMenu* MakeHelpMenu();
    void OnHelp_Launcher(wxCommandEvent& event);
    void OnHelp_About(wxCommandEvent& event);

    static wxFileConfig *m_config;      // configuration file object

private:
    static void GetGlobalDefaults();
    static void SaveGlobalDefaults();

    static wxString m_app_home;         // path to application home directory

    static bool m_do_reconfig;          // when set, bring up config dialog

    // help ensure an orderly shutdown
    static enum term_state_t { RUNNING, TERMINATING, TERMINATED } m_term_state;
    static void SetTermState(term_state_t newstate) { m_term_state = newstate; }
    static term_state_t GetTermState() { return m_term_state; }

    // initialize "static" class members
    static void InitStatics();

    // remember where certain files are located
    // this is a master flag to indicate that the following statics are initialized
    static wxString m_FileDir[FILEREQ_NUM];             // dir where files come from
    static wxString m_Filename[FILEREQ_NUM];            // most recently chosen
    static wxString m_FileFilter[FILEREQ_NUM];          // suffix filter string
    static int      m_FileFilterIdx[FILEREQ_NUM];       // which filter was chosen
    static wxString m_IniGroup[FILEREQ_NUM];            // name in .ini file

    DECLARE_EVENT_TABLE()
};


// =============================================================
// exported by UI
// =============================================================

// inform the UI how far along the simulation is in emulated time
void UiSetSimSeconds(unsigned long seconds, float relative_speed);

// send an error/warning to the user that requires an action to close
void UiAlert(const char *fmt, ...);

// get a YES/NO confirmation
int UiConfirm(const char *fmt, ...);

// get/set an association from the configuration file
// UiConfigReadStr() requires that val be at least 256 chars or more
int UiConfigReadStr(const char *subgroup, const char *key, char *val);
void UiConfigWriteStr(const char *subgroup, const char *key, const char *val);

int HOST_IsAbsolutePath(char *name);

// return the time in milliseconds as a 64b signed integer
int64 UiGetTimeMs(void);

// called periodically by the core emulation so UI events can occur
void UiYield(void);

// go to sleep for approximately ms milliseconds before returning
void UiSleep(unsigned int ms);

// ==================== utility functions ====================

// fetch an association from the configuration file
bool ConfigReadStr(const wxString &subgroup, const wxString &key, wxString *val,
                   const wxString *defaultval = NULL);

// return true if the param was in the init file, otherwise return
// false and stuff the val with the defaultval
bool ConfigReadInt(const wxString &subgroup, const wxString &key, int *val,
                   const int defaultval = 0);

// read the geometry for a window and if it is reasonable, use it,
// otherwise use the supplied default (if any)
void ConfigReadWinGeom(wxWindow *wxwin, const wxString &subgroup,
                       wxRect *default_geom = NULL, bool client_size = true);

void ConfigReadBool(const wxString &subgroup, const wxString &key, bool *val,
                   const bool defaultval = false);

// send a string association to the configuration file
void ConfigWriteStr(const wxString &subgroup, const wxString &key, const wxString *val);

// send a boolean association to the configuration file
void ConfigWriteBool(const wxString &subgroup, const wxString &key, const bool val);

// send an integer association to the configuration file
void ConfigWriteInt(const wxString &subgroup, const wxString &key, const int val);

// write out the geometry for a window
void ConfigWriteWinGeom(wxWindow *wxwin, const wxString &subgroup, bool client_size = true);

#endif // _INCLUDE_UI_SYSTEM_H_
