#ifndef _INCLUDE_UI_FRONT_PANEL_H_
#define _INCLUDE_UI_FRONT_PANEL_H_

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include "wx/fileconf.h"        // required for wxFileConfig

#include "w3300.h"

// ================== exported by UiFrontPanel.cpp ==================

// Define a new frame type: this is going to be our main frame
class UiFrontPanel : public wxFrame
{
public:
    // constructor
    UiFrontPanel();

    // destructor
    ~UiFrontPanel();

// FIXME: here for a hack-around
    wxStatusBar    *m_statbar;      // status bar below frame

private:

    // these make no sense -- declare, but don't define
    UiFrontPanel& operator=(const UiFrontPanel& rhs);     // assignment
    UiFrontPanel(UiFrontPanel& obj);                      // copy constructor

    // ---- event handlers ----

    void OnLoadHex(wxCommandEvent& WXUNUSED(event));
    void OnSaveHex(wxCommandEvent& WXUNUSED(event));
    void OnQuit(wxCommandEvent& WXUNUSED(event));
    void OnCpuReset(wxCommandEvent& WXUNUSED(event));
    void OnSystemReconfigure(wxCommandEvent& WXUNUSED(event));
    void OnClose(wxCloseEvent& WXUNUSED(event));
    void OnButton(wxCommandEvent &event);
    void OnToggleButton(wxCommandEvent &event);
    void OnTimer(wxTimerEvent &event);

    // timer callback to redraw lamps every so often
    void RefreshCb(int n);

    // called just before window is destroyed
    bool UiFrontPanel::Destroy();

    // intercept keystrokes to all controls
    void connectKeyDownEvent(wxWindow* pclComponent);
    void OnKeyDown(wxKeyEvent& event);

    // ---- utility functions ----

    // create menubar
    void MakeMenubar();

    // create bitmaps of indicator lamps
    void MakeLampImages();

    // redraw indicator lamps
    void UpdateLamps();

    // create all the GUI do-dads that constitute the front panel
    void MakeFrontPanel();

    // return the value 0-255 described by the data toggle buttons
    int  GetDataButtons();
    void SetDataButtons(int v);

    // make the mode buttons exclusive
    void SetModeButtons(int id);
    // return which of the modes is currently active (returns ctlId value)
    int GetModeButtons();

    // save/get options to the config file
    void SaveDefaults();
    void GetDefaults();

    // return a wrapped label/button combo
    wxBoxSizer* MakePanelButton(char *label, int id, wxSize size, bool toggle=false);
    // return a wrapped label/bitmap combo
    wxBoxSizer* MakePanelLamp(char *label, int id, int ctl_offset);

    // ---- data members ----
    wxPanel          *m_panel;          // container window for client area
    wxBitmap         *m_lamps[101];     // lamp images, from 0% to 100% intensity
    wxStaticBitmap   *m_lampctl[6*8];   // static bitmap controls
    float             m_lampdrive[6*8]; // simple low pass to model thermal lag
    wxStaticBoxSizer *m_boxDataBtns;    // wraps around data input buttons

    wxTimer *m_refresh_timer;

    // any class wishing to process wxWindows events must use this macro
    DECLARE_EVENT_TABLE()
};

#endif // _INCLUDE_UI_FRONT_PANEL_H_
