#ifndef _IODEVICE_H_
#define _IODEVICE_H_

// This is an abstract class that any attached I/O device (TTY, cassette
// tape controller, etc) derives from.  This is the conduit whereby the
// CPU can poll the device.  The reason why address is included is that
// one device can contain more than one addressible function.  For instance,
// the TTY device has an address for input and an address for output.

// abstract class for all I/O devices
class IoDevice
{
public:
    virtual ~IoDevice() { }

    // power on reset
    virtual void Reset() = 0;

    // front panel clear button
    virtual void Clear() = 0;

    // write to device control register
    virtual void WrControl(int addr, int data) = 0;

    // read from device status register
    virtual int RdStatus(int addr) const = 0;

    // write device data byte
    virtual void WrData(int addr, int data) = 0;

    // read device data byte
    virtual int RdData(int addr) const = 0;

    // interrupt acknowledge
    virtual void IAck(int addr) = 0;
};

#endif // _IODEVICE_H_
